/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.ipv6;

import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.jdm.eui.MultiLineLabel;
import java.awt.Component;

public class IPv6addressRO
extends MultiLineLabel
implements JDMInput {
    protected boolean hasErrorValue = false;
    protected boolean ignoreValue = false;

    public IPv6addressRO() {
    }

    public IPv6addressRO(String string) {
        super(string);
    }

    public void setText(String string) {
        super.setText(string);
        this.hasErrorValue = false;
        this.ignoreValue = false;
        ((Component)((Object)this)).invalidate();
    }

    public Object getValue() {
        return new String(this.getText());
    }

    public String toString() {
        return new String(this.getText());
    }

    public void setValue(String string) {
        this.setText(string);
        this.hasErrorValue = false;
        this.ignoreValue = false;
    }

    public void setValue(Object object) {
        this.hasErrorValue = false;
        this.ignoreValue = false;
        if (object instanceof String) {
            this.setText((String)object);
            return;
        }
        if (object instanceof OctetString) {
            this.setText(this.toIPv6(((OctetString)object).toString(), ((OctetString)object).value));
            return;
        }
        if (object instanceof SpecialValue) {
            this.setText(object.toString());
            this.hasErrorValue = true;
            if (object instanceof NotSupported) {
                this.ignoreValue = true;
                return;
            }
            this.ignoreValue = false;
            return;
        }
        this.setText(object.toString());
    }

    private String toIPv6(String string, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = true;
        if (string.length() != 32) {
            return string;
        }
        if (string.equals("00000000000000000000000000000000")) {
            return "::";
        }
        if (string.equals("00000000000000000000000000000001")) {
            return "::1";
        }
        int n2 = 0;
        while (n2 < 32) {
            String string2 = string.substring(n2, n2 + 4);
            if (string2.equals("0000")) {
                ++n;
                if (!bl2) {
                    stringBuffer.append("0");
                }
                if (n == 6 && n2 == 20) {
                    bl = true;
                }
            } else {
                if (n == 1) {
                    stringBuffer.append("0:");
                }
                if (n > 1) {
                    stringBuffer.append(":");
                    bl2 = false;
                    if (bl3) {
                        stringBuffer.append(":");
                    }
                }
                string2 = this.zeroStrip(string2);
                stringBuffer.append(string2);
                if (n == 5 && n2 == 20 && (string2.equals("ffff") || string2.equals("FFFF"))) {
                    bl = true;
                }
                n = 0;
                bl3 = false;
            }
            if (n2 == 28) {
                if (n == 1) {
                    stringBuffer.append("0");
                }
                if (n > 1) {
                    stringBuffer.append(":");
                }
                if (n == 8) {
                    stringBuffer.append(":");
                }
            } else if (n == 0) {
                stringBuffer.append(":");
            }
            if (bl) {
                if (n > 4) {
                    stringBuffer.append(":");
                }
                if (n == 6) {
                    stringBuffer.append(":");
                }
                IPAddress iPAddress = new IPAddress(byArray, 12);
                stringBuffer.append(iPAddress.getIpAddress());
                break;
            }
            n2 += 4;
        }
        return stringBuffer.toString();
    }

    private String zeroStrip(String string) {
        String string2 = string;
        if (string2 != null && string2.trim() != null) {
            int n = 0;
            while (n < string.length()) {
                if (string2.startsWith("0")) {
                    string2 = string2.substring(1);
                }
                ++n;
            }
        }
        return string2;
    }

    public boolean isValidValue() {
        return !this.hasErrorValue;
    }

    public boolean ignoreValue() {
        return this.ignoreValue;
    }
}

